/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.wcl;

import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmListModel;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.impl.MutableListModelTreeImpl;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.psw.wcl.core.AContext;
import com.ibm.psw.wcl.core.ExtendedListSelectionEvent;
import com.ibm.psw.wcl.core.IExtendedListSelectionListener;
import com.ibm.psw.wcl.core.form.IExtendedListModel;
import com.ibm.psw.wcl.core.form.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ListDataListener;

public class WclGlueListModel
implements IExtendedListModel {
    private static final String TRACE_MASKT = "XPMWGLLT";
    private static final String TRACE_MASKF = "XPMWGLLF";
    private static final String TRACE_MASKD = "XPMWGLLD";
    private static final int[] EMPTY_SELECTION = new int[0];
    private static int wclGlueListModelId = 0;
    private boolean wrapWithOptionObjects = false;
    private PmListModel model = null;
    private String id = Integer.toString(WclGlueListModel.getWclGlueListModelId()) + "-";
    private List listSelectionListeners;
    private List listDataListeners;
    private boolean valueIsAdjusting;
    private int selectionMode = 0;
    private int anchorIndex;
    private int leadIndex;

    private static synchronized int getWclGlueListModelId() {
        return wclGlueListModelId++;
    }

    public WclGlueListModel(PmListModel model) {
        this.model = model;
        this.listSelectionListeners = new ArrayList();
        this.listDataListeners = new ArrayList();
    }

    public void setWrapWithOptionObjects(boolean wrapWithOptionObjects) {
        this.wrapWithOptionObjects = wrapWithOptionObjects;
    }

    public PmListModel getRawModel() {
        return this.model;
    }

    public int getSize() {
        return this.model.getSize();
    }

    public Object getElementAt(int index) {
        if (this.wrapWithOptionObjects) {
            Option option = new Option(this.id + index, this.model.getElementAt(index));
            return option;
        }
        return this.model.getElementAt(index);
    }

    public void setSelectionInterval(int index0, int index1, AContext ac) {
        int[] newSel;
        int newSelIntervalSize;
        int[] currentSel;
        Trace.trace(TRACE_MASKT, "setSelectionInterval(" + index0 + "," + index1 + ")");
        if (this.selectionMode == 0) {
            index1 = index0;
        }
        if ((currentSel = this.model.getSelected()) == null) {
            currentSel = EMPTY_SELECTION;
        }
        if ((newSelIntervalSize = index0 - index1) < 0) {
            newSelIntervalSize *= -1;
        }
        ++newSelIntervalSize;
        if (index0 < 0 || index1 < 0) {
            newSel = new int[]{};
        } else {
            newSel = new int[newSelIntervalSize];
            for (int i = 0; i < newSelIntervalSize; ++i) {
                newSel[i] = index0 == index1 ? index0 : (index0 < index1 ? index0 + i : index1 + i);
            }
        }
        if (!Arrays.equals(currentSel, newSel)) {
            this.anchorIndex = index0;
            this.leadIndex = index1;
            this.model.setSelected(newSel);
            Trace.trace(TRACE_MASKF, "updated model selection");
            ExtendedListSelectionEvent e = new ExtendedListSelectionEvent((Object)this, index0, index1, ac);
            Trace.trace(TRACE_MASKF, "about to fire events");
            Iterator iterator = ((List)((ArrayList)this.listSelectionListeners).clone()).iterator();
            while (iterator.hasNext()) {
                IExtendedListSelectionListener listener = (IExtendedListSelectionListener)iterator.next();
                listener.valueChanged(e);
            }
            Trace.trace(TRACE_MASKF, "fired events");
        }
    }

    public int getMaxSelectionIndex() {
        int[] sel = this.model.getSelected();
        if (sel == null || sel.length == 0) {
            return -1;
        }
        return sel[sel.length - 1];
    }

    public void addSelectionInterval(int index0, int index1, AContext ac) {
        int newSelIntervalSize;
        int[] currentSel;
        Trace.trace(TRACE_MASKT, "addSelectionInterval(" + index0 + "," + index1 + ")");
        if (index0 < 0 || index1 < 0) {
            this.clearSelection(ac);
            return;
        }
        if (this.selectionMode == 0) {
            index1 = index0;
            this.clearSelection(ac);
        }
        if ((currentSel = this.model.getSelected()) == null) {
            currentSel = EMPTY_SELECTION;
        }
        if ((newSelIntervalSize = index0 - index1) < 0) {
            newSelIntervalSize *= -1;
        }
        int[] newSelAddition = new int[++newSelIntervalSize];
        for (int i = 0; i < newSelAddition.length; ++i) {
            newSelAddition[i] = index0 == index1 ? index0 : (index0 > index1 ? index1 - 1 : index0 + i);
        }
        int uniqueEntries = currentSel.length;
        for (int i = 0; i < newSelAddition.length; ++i) {
            boolean found = false;
            for (int j = 0; j < currentSel.length; ++j) {
                if (currentSel[j] != newSelAddition[i]) continue;
                found = true;
                j = currentSel.length;
            }
            if (found) continue;
            ++uniqueEntries;
        }
        int[] newSelection = new int[uniqueEntries];
        System.arraycopy(currentSel, 0, newSelection, 0, currentSel.length);
        uniqueEntries = currentSel.length;
        for (int i = 0; i < newSelAddition.length; ++i) {
            boolean found = false;
            for (int j = 0; j < currentSel.length; ++j) {
                if (currentSel[j] != newSelAddition[i]) continue;
                found = true;
                j = currentSel.length;
            }
            if (found) continue;
            newSelection[uniqueEntries++] = newSelAddition[i];
        }
        Arrays.sort(newSelection);
        this.anchorIndex = index0;
        this.leadIndex = index1;
        if (newSelection.length != currentSel.length) {
            this.model.setSelected(newSelection);
            ExtendedListSelectionEvent e = new ExtendedListSelectionEvent((Object)this, index0, index1, ac);
            Iterator iterator = ((List)((ArrayList)this.listSelectionListeners).clone()).iterator();
            while (iterator.hasNext()) {
                IExtendedListSelectionListener listener = (IExtendedListSelectionListener)iterator.next();
                listener.valueChanged(e);
            }
        }
    }

    public boolean isSelectedIndex(int index) {
        int[] sel = this.model.getSelected();
        if (sel == null) {
            return false;
        }
        for (int i = 0; i < sel.length; ++i) {
            if (sel[i] != index) continue;
            return true;
        }
        return false;
    }

    public void removeSelectionInterval(int index0, int index1, AContext ac) {
        int remSelIntervalSize;
        int[] currentSel;
        Trace.trace(TRACE_MASKT, "removeSelectionInterval(" + index0 + "," + index1 + ")");
        if (this.selectionMode == 0) {
            index1 = index0;
        }
        if ((currentSel = this.model.getSelected()) == null) {
            currentSel = EMPTY_SELECTION;
        }
        if ((remSelIntervalSize = index0 - index1) < 0) {
            remSelIntervalSize *= -1;
        }
        int[] selSubtraction = new int[++remSelIntervalSize];
        for (int i = 0; i < selSubtraction.length; ++i) {
            selSubtraction[i] = index0 == index1 ? index0 : (index0 > index1 ? index1 - 1 : index0 + i);
        }
        int uniqueEntries = currentSel.length;
        for (int i = 0; i < selSubtraction.length; ++i) {
            boolean found = false;
            for (int j = 0; j < currentSel.length; ++j) {
                if (currentSel[j] != selSubtraction[i]) continue;
                found = true;
                j = currentSel.length;
            }
            if (!found) continue;
            --uniqueEntries;
        }
        int[] newSelection = new int[uniqueEntries];
        uniqueEntries = 0;
        for (int i = 0; i < currentSel.length; ++i) {
            boolean found = false;
            for (int j = 0; j < selSubtraction.length; ++j) {
                if (currentSel[i] != selSubtraction[j]) continue;
                found = true;
                j = selSubtraction.length;
            }
            if (found) continue;
            newSelection[uniqueEntries++] = currentSel[i];
        }
        Arrays.sort(newSelection);
        this.anchorIndex = index0;
        this.leadIndex = index1;
        if (newSelection.length != currentSel.length) {
            this.model.setSelected(newSelection);
            ExtendedListSelectionEvent e = new ExtendedListSelectionEvent((Object)this, index0, index1, ac);
            Iterator iterator = ((List)((ArrayList)this.listSelectionListeners).clone()).iterator();
            while (iterator.hasNext()) {
                IExtendedListSelectionListener listener = (IExtendedListSelectionListener)iterator.next();
                listener.valueChanged(e);
            }
        }
    }

    public int getMinSelectionIndex() {
        int[] sel = this.model.getSelected();
        if (sel == null || sel.length == 0) {
            return -1;
        }
        return sel[0];
    }

    public int getLeadSelectionIndex() {
        return this.leadIndex;
    }

    public void setLeadSelectionIndex(int index, AContext ac) {
        this.leadIndex = index;
    }

    public int getAnchorSelectionIndex() {
        return this.anchorIndex;
    }

    public void setAnchorSelectionIndex(int index, AContext ac) {
        this.anchorIndex = index;
    }

    public void insertIndexInterval(int index, int length, AContext ac, boolean before) {
        Trace.trace(TRACE_MASKT, "insertIndexInterval(" + index + "," + length + "," + before + ")");
        Trace.trace(TRACE_MASKF, "WclGlueListModel -- Not implemented!! --");
    }

    public void removeIndexInterval(int index0, int index1, AContext ac) {
        Trace.trace(TRACE_MASKT, "removeIndexInterval(" + index0 + "," + index1 + ")");
        Trace.trace(TRACE_MASKF, "WclGlueListModel -- Not implemented!! --");
        this.anchorIndex = index0;
        this.leadIndex = index1;
    }

    public void clearSelection(AContext ac) {
        Trace.trace(TRACE_MASKT, "clearSelection()");
        int[] currentSel = this.model.getSelected();
        if (currentSel == null) {
            currentSel = EMPTY_SELECTION;
        }
        if (!Arrays.equals(currentSel, EMPTY_SELECTION)) {
            this.model.setSelected(EMPTY_SELECTION);
            ExtendedListSelectionEvent e = new ExtendedListSelectionEvent((Object)this, -1, -1, ac);
            Iterator iterator = ((List)((ArrayList)this.listSelectionListeners).clone()).iterator();
            while (iterator.hasNext()) {
                IExtendedListSelectionListener listener = (IExtendedListSelectionListener)iterator.next();
                listener.valueChanged(e);
            }
        }
    }

    public boolean isSelectionEmpty() {
        int[] currentSel = this.model.getSelected();
        if (currentSel == null) {
            return true;
        }
        return currentSel.length == 0;
    }

    public void setSelectionMode(int selectionMode) {
        switch (selectionMode) {
            case 0: 
            case 1: 
            case 2: {
                this.selectionMode = selectionMode;
                if (!(this.model instanceof MutableListModelTreeImpl)) break;
                ((MutableListModelTreeImpl)this.model).setSelectionPolicy(selectionMode);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid selectionMode");
            }
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting, AContext ac) {
        this.valueIsAdjusting = valueIsAdjusting;
    }

    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void addListSelectionListener(IExtendedListSelectionListener x) {
        if (x != null) {
            this.listSelectionListeners.add(x);
        }
    }

    public void removeListSelectionListener(IExtendedListSelectionListener x) {
        if (x != null) {
            this.listSelectionListeners.remove(x);
        }
    }

    public void addListDataListener(ListDataListener l) {
        if (l != null) {
            this.listDataListeners.add(l);
        }
    }

    public void removeListDataListener(ListDataListener l) {
        if (l != null) {
            this.listDataListeners.remove(l);
        }
    }
}

